<?php

namespace Drupal\cg\EventSubscriber;

use Drupal\cg\ContentGuideEvents;
use Drupal\cg\EventDispatcher\AlterFieldSettingsEventInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Content guide event subscriber for entity_reference fields.
 */
class EntityReferenceEventSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a new ParagraphsEventSubscriber object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager.
   */
  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
  ) {

  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public static function getSubscribedEvents() {
    return [
      ContentGuideEvents::ALTER_FIELD_SETTINGS => 'fieldSettingsAlter',
    ];
  }

  /**
   * Alter content guide field settings for entity_reference.
   *
   * @param \Drupal\cg\EventDispatcher\AlterFieldSettingsEventInterface $event
   *   The event.
   */
  public function fieldSettingsAlter(AlterFieldSettingsEventInterface $event): void {
    $items = $event->getItems();
    if (is_null($items)) {
      return;
    }

    /** @var \Drupal\Core\Field\FieldDefinitionInterface $definition */
    $definition = $items->getFieldDefinition();

    if ($definition->getType() !== 'entity_reference') {
      // Seems this is not a field provided by entity_reference.
      return;
    }

    $settings =& $event->getFieldSettings();
    switch ($settings['display_type']) {
      case 'tooltip':
        // Attach tooltips to title of paragraphs field.
        $settings['attach_selector'] = 'strong:first-of-type, .form-item__label';
        break;

      case 'description':
        // Attach description to field description.
        $settings['attach_selector'] = '.description:first-of-type';
        break;
    }
  }

}
