<?php

namespace Drupal\cg\EventSubscriber;

use Drupal\cg\ContentGuideEvents;
use Drupal\cg\EventDispatcher\AlterFieldSettingsEventInterface;
use Drupal\Core\Entity\EntityFieldManagerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Content guide event subscriber for media fields.
 */
class MediaEventSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a new ParagraphsEventSubscriber object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager.
   * @param \Drupal\Core\Entity\EntityFieldManagerInterface $entityFieldManager
   *   The entity field manager.
   */
  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
    protected EntityFieldManagerInterface $entityFieldManager,
  ) {

  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public static function getSubscribedEvents() {
    return [
      ContentGuideEvents::ALTER_FIELD_SETTINGS => 'fieldSettingsAlter',
    ];
  }

  /**
   * Alter content guide field settings for media fields.
   *
   * @param \Drupal\cg\EventDispatcher\AlterFieldSettingsEventInterface $event
   *   The event.
   */
  public function fieldSettingsAlter(AlterFieldSettingsEventInterface $event): void {
    $items = $event->getItems();
    if (is_null($items)) {
      return;
    }

    /** @var \Drupal\Core\Field\FieldDefinitionInterface $definition */
    $definition = $items->getFieldDefinition();

    $target_type = $definition->getSetting('target_type');
    if ($target_type !== 'media') {
      return;
    }

    $settings =& $event->getFieldSettings();

    switch ($settings['display_type']) {
      case 'tooltip':
        // Attach tooltips to fieldset legend of media field.
        $settings['attach_selector'] = 'legend:first-of-type .fieldset__label';
        break;

      case 'description':
        // Attach description to fieldset description.
        $settings['attach_selector'] = '.description:first-of-type';
        break;
    }
  }

}
