<?php

namespace Drupal\cg\EventSubscriber;

use Drupal\cg\ContentGuideEvents;
use Drupal\cg\EventDispatcher\AlterFieldSettingsEventInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Content guide event subscriber for paragraphs fields.
 */
class ParagraphsEventSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a new ParagraphsEventSubscriber object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager.
   */
  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
  ) {

  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public static function getSubscribedEvents() {
    return [
      ContentGuideEvents::ALTER_FIELD_SETTINGS => 'fieldSettingsAlter',
    ];
  }

  /**
   * Alter content guide field settings for paragraphs.
   *
   * @param \Drupal\cg\EventDispatcher\AlterFieldSettingsEventInterface $event
   *   The event.
   */
  public function fieldSettingsAlter(AlterFieldSettingsEventInterface $event): void {
    $widget = $event->getWidget();
    if (is_null($widget)) {
      return;
    }

    $plugin_definition = $widget->getPluginDefinition();
    if (!is_array($plugin_definition) || !isset($plugin_definition['provider'])) {
      return;
    }

    if ($plugin_definition['provider'] !== 'paragraphs') {
      // Seems this is not a field provided by Paragraphs.
      return;
    }

    $settings =& $event->getFieldSettings();
    switch ($settings['display_type']) {
      case 'tooltip':
        // Attach tooltips to title of paragraphs field.
        $settings['attach_selector'] = 'strong:first-of-type, thead .label';
        break;

      case 'description':
        // Attach description to field description.
        $settings['attach_selector'] = '.description:first-of-type';
        break;
    }
  }

}
