<?php

namespace Drupal\cg;

/**
 * Interface for third party helper for content_guide.
 */
interface ThirdPartyHelperInterface {

  /**
   * Build a third party settings form.
   *
   * @param array $settings
   *   List of third party settings used to build the form.
   *
   * @return array
   *   Returns the form array to be built.
   */
  public function buildForm(array $settings): array;

  /**
   * Get the third party settings summary.
   *
   * @param array<string, mixed> $settings
   *   Content guide settings.
   *
   * @return array
   *   Summary for third party settings.
   */
  public function getSummary(array $settings): array;

  /**
   * Get list of display options.
   *
   * @return array<string, \Drupal\Core\StringTranslation\TranslatableMarkup>
   *   A list of display options.
   */
  public function getDisplayOptions(): array;

}
