<?php

namespace Drupal\Tests\cg\Traits;

use Drupal\Core\File\FileSystemInterface;
use org\bovigo\vfs\vfsStream;

/**
 * Helper functions for file system related tasks.
 */
trait FileSystemTrait {

  /**
   * Setup the test file system.
   */
  public function setupFileSystem(): void {
    $this->fileSystem = $this->createMock(FileSystemInterface::class);

    // Setup virtual file system (vfsStream).
    $vfs_root = vfsStream::setup('root');
    $test_directory_absolute = vfsStream::url('root/content_guide_test');

    // Create virtual directory structure and files.
    $test_directory = vfsStream::newDirectory('content_guide_test')->at($vfs_root);
    vfsStream::newFile('README.md')->at($test_directory)->setContent('Test README');
    vfsStream::newFile('ignore.txt')->at($test_directory)->setContent('Ignore me');
    vfsStream::newFile('guide.md')->at($test_directory)->setContent('# Hello EN');
    vfsStream::newFile('guide.de.md')->at($test_directory)->setContent('# Hallo DE');
    vfsStream::newFile('altered.md')->at($test_directory)->setContent('# Altered content');
    vfsStream::newFile('xss.md')->at($test_directory)->setContent('<script>alert(1)</script>Safe');

    $sub_directory = vfsStream::newDirectory('subdir')->at($test_directory);
    vfsStream::newFile('ANOTHER.md')->at($sub_directory)->setContent('Another file');

    $nested_directory = vfsStream::newDirectory('deep')->at($sub_directory);
    vfsStream::newFile('nested.md')->at($nested_directory)->setContent('Nested file');

    // Configure Config mock.
    $this->config->method('get')
      ->with('document_base_path')
      ->willReturn('content_guide_test');

    // Configure FileSystem mock.
    $expected_realpath_arg = \DRUPAL_ROOT . '/content_guide_test';
    $this->fileSystem->method('realpath')
      ->with($expected_realpath_arg)
      ->willReturn($test_directory_absolute);
  }

}
