# Change Mail Page

Provides a separate page for users to change their email address.

## Features

- Adds a "Change Email" tab on user profile pages
- Requires current password to change email
- Removes email field from main user edit form (for non-admins)
- Admins can still edit email on the main user form

## Requirements

- Drupal 10 or 11

## Installation

```bash
composer require drupal/change_mail_page
drush en change_mail_page
```

## Usage

After enabling the module:

1. Users will see a new "Change Email" tab on their profile
2. Navigate to `/user/{uid}/change-mail`
3. Enter new email and current password
4. Submit to change email

## Permissions

Uses Drupal's built-in `user.update` entity access. Users can change their own email, admins can change any user's email.

## Related Modules

- [Password Separate Form](https://www.drupal.org/project/change_pwd_page) - Similar module for password changes

## License

GPL-2.0-or-later

