# Change Password Page Module

The Change Password Page module provides a dedicated page for users to change their passwords, separate from the main user account edit form. This improves user experience by isolating password changes from other account settings, reducing confusion and eliminating the need to load all account fields when users only want to update their password.

## Features

- **Separate password change form**: Dedicated page at `/user/change-password` for authenticated users
- **Enhanced user experience**: Clean, focused interface for password updates
- **Password reset integration**: Custom password reset workflow with one-time login links
- **Password Policy compatibility**: Automatic integration with the Password Policy module
- **Security features**: Current password verification and secure token handling

For a full description of the module, visit the [project page](https://www.drupal.org/project/change_pwd_page).

Submit bug reports and feature suggestions, or track changes in the [issue queue](https://www.drupal.org/project/issues/change_pwd_page).

[![pipeline status](https://git.drupalcode.org/project/change_pwd_page/badges/2.0.x/pipeline.svg)](https://git.drupalcode.org/project/change_pwd_page/-/commits/2.0.x)
[![coverage report](https://git.drupalcode.org/project/change_pwd_page/badges/2.0.x/coverage.svg)](https://git.drupalcode.org/project/change_pwd_page/-/commits/2.0.x)

## Table of Contents

- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Usage](#usage)
- [Password Reset Workflow](#password-reset-workflow)
- [Maintainers](#maintainers)

## Requirements

There are no additional requirements beyond Drupal core.

## Installation

Install as you would normally install a contributed Drupal module:

1. **Composer**:
   ```bash
   composer require drupal/change_pwd_page
   ```


2. **Enable the module**:
   - Via Drush: `drush en change_pwd_page`
   - Via UI: Navigate to Extend (`/admin/modules`) and enable "Password Separate Form"

For detailed instructions, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

The module works out of the box with no configuration required. However, it automatically integrates with:

- **Password Policy module**: If installed, the module updates the password policy configuration to use the new change password route

## Usage

### For End Users

1. **Access the change password form**:
   - Navigate to `/user/change-password` (redirects to your personal form)
   - Or visit `/user/{uid}/change-password` directly
   - Or use the "Change Password" menu item in your account menu

2. **Change your password**:
   - Enter your current password (required for security)
   - Enter your new password twice for confirmation
   - Submit the form

### For Administrators

- Users can access their own password change forms via the routes above
- Administrators with appropriate permissions can change other users' passwords
- The module adds a "Change Password" local task tab to user profile pages

## Password Reset Workflow

The module provides an enhanced password reset experience:

1. **One-time login links**: Custom handling of password reset emails
2. **Secure token system**: Uses cryptographically secure tokens for password reset sessions
3. **Expiration handling**: Proper validation of reset link expiration
4. **User-friendly messaging**: Clear instructions and status messages throughout the process

### Reset Process

1. User requests password reset via `/user/password`
2. System generates secure reset link: `/user/reset/{uid}/{timestamp}/{hash}/new/login`
3. User clicks link and is presented with one-time login form
4. After login, user is redirected to change password form with bypass token
5. User can set new password without entering current password



## Maintainers

- Gaurav Pahuja - [gaurav.pahuja](https://www.drupal.org/u/gaurav.pahuja)
- Pushpinder Rana - [er.pushpinderrana](https://www.drupal.org/u/er.pushpinderrana)
- Steven Ayers - [bluegeek9](https://www.drupal.org/u/bluegeek9)
- Adrian Cid Almaguer - [adriancid](https://www.drupal.org/u/adriancid)
- Divesh Kumar - [diveshkumar](https://www.drupal.org/u/diveshkumar)
- [madhusudanmca](https://www.drupal.org/u/madhusudanmca)

