# Charts Plotly

This is a module that integrates the [Plotly.js](https://plotly.com/javascript/)
library with the [Charts](https://www.drupal.org/project/charts) module.

"Plotly.js is an open-source JavaScript charting library for creating
interactive visualizations on the web. Built on top of D3.js and WebGL,
it provides a high-level declarative API for creating publication-quality
graphs." (Plotly.js website).

The project is open-source (MIT license) and free to use in commercial
applications.

Available chart types and features include:
- [Area](https://plotly.com/javascript/filled-area-plots/),
- [Bar](https://plotly.com/javascript/bar-charts/),
- [Box Plot](https://plotly.com/javascript/box-plots/),
- [Bubble](https://plotly.com/javascript/bubble-charts/),
- [Candlestick](https://plotly.com/javascript/candlestick-charts/),
- [Column](https://plotly.com/javascript/bar-charts/),
- [Donut](https://plotly.com/javascript/pie-charts/),
- [Gauge](https://plotly.com/javascript/gauge-charts/),
- [Heatmap](https://plotly.com/javascript/heatmaps/),
- [Line](https://plotly.com/javascript/line-charts/),
- [Pie](https://plotly.com/javascript/pie-charts/),
- [Radar](https://plotly.com/javascript/radar-chart/),
- [Scatter](https://plotly.com/javascript/line-and-scatter/),
- [Spline](https://plotly.com/javascript/line-charts/),
- And many more advanced 3D and scientific chart types.

The Charts module allows for combination charts either through Views or
the Charts API.

## Table of contents

- Requirements
- Recommended modules
- Installation
- Configuration
- Maintainers

## Requirements

This module requires the following modules:

- [Charts](https://www.drupal.org/project/charts) (version 5.1.6 or higher)

## Recommended modules

If you don't want to use data already in your site, here are a few
recommended modules:

- [Charts AI Agents](https://www.drupal.org/project/charts_ai_agents)
- [Views CSV Source](https://www.drupal.org/project/views_csv_source)
- [Views JSON Source](https://www.drupal.org/project/views_json_source)
- [Views Database Connector](https://www.drupal.org/project/views_database_connector)
- [External Entities](https://www.drupal.org/project/external_entities)
- [Views Fields On/Off](https://www.drupal.org/project/views_fields_on_off)

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

### Library Installation with Composer

This module uses [Asset Packagist](https://asset-packagist.org/) to bring in
the Plotly.js library. Before you require the module with Composer, you need
to make sure the following exist in your composer.json file:

1. The Asset Packagist repository is added to the "repositories" section.
   ```
   "repositories": [
     {
       "type": "composer",
        "url": "https://packages.drupal.org/8"
      },
      {
        "type": "composer",
        "url": "https://asset-packagist.org"
       }
   ],
   ```

2. The "oomphinc/composer-installers-extender" package is installed.
   This package allows you to install libraries into the "/libraries" directory
   instead of the default "/vendor" directory.
   ```
   composer require --prefer-dist oomphinc/composer-installers-extender
   ```

3. The installer types and paths are set in the "extra" section of your
   composer.json file. This tells Composer to install Plotly.js into the
   "/libraries/plotly.js" directory.
   ```
   "extra": {
     "installer-types": ["npm-asset", "bower-asset"],
     "installer-paths": {
       "web/libraries/plotly.js": ["npm-asset/plotly.js-dist-min"],
       "web/libraries/{$name}": [
         "type:drupal-library",
         "type:bower-asset",
         "type:npm-asset"
       ]
     }
   }
   ```

4. Install the module using Composer:
   ```
   composer require drupal/charts_plotly
   ```

### Using npm (new)

If you are using npm for JavaScript assets and have a build step that would
run npm install (for example), then you can add a package.json file to your
site root that looks like this:

```
  {
    "name": "my_site",
    "private": true,
    "scripts": {
      "postinstall": "npm run libraries:copy --workspaces --if-present"
    },
    "workspaces": [
      "web/modules/contrib/charts_plotly"
    ]
  }
```

If you already have a package.json file present in your site root, then edit
it to include the "postinstall" script and the "workspaces".

`npm install` will then add your JS files to the appropriate library
directories (e.g. web/libraries/plotly.js).

This assumes that you are using the "web" directory and the charts_plotly 
module is in a directory like "web/modules/contrib/charts_plotly".

## Configuration

1. Enable the module at Administration > Extend.
2. Set Plotly as your default charting library
   at /admin/config/content/charts.
3. Create your chart! There are three ways to create a chart:
  - Create a view and use the "Chart" format
  - Add a chart field to your entity type (e.g. node, user, etc.)
  - Use the Charts API to create a chart programmatically

## Maintainers

- Current maintainers:
  - [Daniel Cothran] - [andileco](https://www.drupal.org/u/andileco)

## Disclosure

This module was created with the help of AI.
