<?php

declare(strict_types=1);

namespace Drupal\Tests\charts_plotly\Unit\Plugin\chart\Library;

use Drupal\charts_plotly\Plugin\chart\Library\Plotly;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Tests\UnitTestCase;

/**
 * Tests the Plotly library plugin.
 *
 * @group charts
 * @coversDefaultClass \Drupal\charts_plotly\Plugin\chart\Library\Plotly
 * @use \Drupal\charts\Plugin\chart\Library\ChartBase
 */
class PlotlyTest extends UnitTestCase {

  /**
   * The element info manager.
   *
   * @var \Drupal\Core\Render\ElementInfoManagerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $elementInfo;

  /**
   * The plugin manager for chart types.
   *
   * @var \Drupal\charts\TypeManager|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $pluginManagerChartsType;

  /**
   * The form builder.
   *
   * @var \Drupal\Core\Form\FormBuilderInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $formBuilder;

  /**
   * The module handler.
   *
   * @var \Drupal\Core\Extension\ModuleHandlerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $moduleHandler;

  /**
   * The Plotly plugin.
   *
   * @var \Drupal\charts_plotly\Plugin\chart\Library\Plotly
   */
  protected $plugin;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $container = new ContainerBuilder();

    $string_translation = $this->getStringTranslationStub();
    $container->set('string_translation', $string_translation);

    // This mock is required by the parent ChartBase class.
    $this->moduleHandler = $this->createMock('Drupal\Core\Extension\ModuleHandlerInterface');
    $container->set('module_handler', $this->moduleHandler);

    $this->elementInfo = $this->createMock('Drupal\Core\Render\ElementInfoManagerInterface');
    $container->set('element_info', $this->elementInfo);

    $this->pluginManagerChartsType = $this->createMock('Drupal\charts\TypeManager');
    $container->set('plugin.manager.charts_type', $this->pluginManagerChartsType);

    $this->formBuilder = $this->createMock('Drupal\Core\Form\FormBuilderInterface');
    $container->set('form_builder', $this->formBuilder);

    \Drupal::setContainer($container);

    $this->plugin = Plotly::create($container, [], 'plotly', [
      'id' => 'plotly',
      'label' => 'Plotly',
      'provider' => 'charts_plotly',
    ]);

  }

  /**
   * Tests the creation of the Plotly plugin.
   *
   * @covers ::create
   */
  public function testCreate(): void {
    $container = \Drupal::getContainer();
    $plugin = Plotly::create($container, [], 'plotly', [
      'id' => 'plotly',
      'label' => 'Plotly',
      'provider' => 'charts_plotly',
    ]);
    $this->assertInstanceOf(Plotly::class, $plugin);
  }

  /**
   * Tests the constructor of the Plotly plugin.
   *
   * @covers ::__construct
   */
  public function testConstruct(): void {
    $plugin = new Plotly(
      [],
      'plotly',
      [
        'id' => 'plotly',
        'label' => 'Plotly',
        'provider' => 'charts_plotly',
      ],
      $this->elementInfo,
      $this->pluginManagerChartsType,
      $this->formBuilder,
    );

    $this->assertInstanceOf(Plotly::class, $plugin);
  }

}
