/**
 * @file
 * JavaScript integration between Plotly.js and Drupal.
 */
/* global Plotly */
(function (Drupal, once, Plotly) {
  Drupal.behaviors.chartsPlotly = {
    attach(context) {
      once('charts-plotly-chart', '.charts-plotly', context).forEach(
        function (element) {
          const contents = new Drupal.Charts.Contents();
          const id = element.id;
          const chartData = contents.getData(id);
          if (!chartData) {
            return;
          }

          const data = chartData.data || [];
          const layout = chartData.layout || {};
          const config = chartData.config || {
            responsive: true,
            displaylogo: false,
          };

          Plotly.newPlot(id, data, layout, config);

          if (
            element.nextElementSibling &&
            element.nextElementSibling.hasAttribute(
              'data-charts-debug-container',
            )
          ) {
            element.nextElementSibling.querySelector('code').innerText =
              JSON.stringify({ data, layout, config }, null, ' ');
          }
        },
      );
    },
  };
})(Drupal, once, Plotly);
