import { Plugin } from 'ckeditor5/src/core';
import { ButtonView } from 'ckeditor5/src/ui';

export default class ChartTextFilterUI extends Plugin {
  static get pluginName() {
    return 'ChartTextFilterUI';
  }

  init() {
    const { editor } = this;

    // Register the insertChart button.
    editor.ui.componentFactory.add('insertChart', (locale) => {
      const buttonView = new ButtonView(locale);

      // Use inline SVG
      const icon =
        '<svg width="20" height="20" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg"><path d="M50,15 C50,15 20,45 20,65 C20,85 35,95 50,95 C65,95 80,85 80,65 C80,45 50,15 50,15Z" fill="#0095D5"/><rect x="28" y="65" width="10" height="15" rx="1" fill="black"/><rect x="44" y="55" width="10" height="25" rx="1" fill="black"/><rect x="60" y="50" width="10" height="30" rx="1" fill="black"/></svg>';

      buttonView.set({
        label: 'Insert Chart',
        icon,
        tooltip: true,
      });

      // Get the command.
      const command = editor.commands.get('insertChart');

      // Bind button state to command if it exists.
      if (command) {
        buttonView.bind('isEnabled').to(command, 'isEnabled');
      }

      // Execute the command when clicked.
      this.listenTo(buttonView, 'execute', () => {
        editor.execute('insertChart');
        editor.editing.view.focus();
      });

      return buttonView;
    });
  }
}
