<?php

namespace Drupal\charts_text_filter\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * An AJAX command for inserting a chart into CKEditor.
 */
final class InsertChartCommand implements CommandInterface {

  /**
   * The HTML content of the chart to insert.
   *
   * @var string
   */
  protected $chartHtml;

  /**
   * Constructs an InsertChartCommand object.
   *
   * @param string $chart_html
   *   The chart HTML to insert.
   */
  public function __construct(string $chart_html) {
    $this->chartHtml = $chart_html;
  }

  /**
   * {@inheritdoc}
   */
  public function render(): array {
    return [
      'command' => 'insertChartCommand',
      'chartHtml' => $this->chartHtml,
    ];
  }

}
