const path = require('path');
const webpack = require('webpack');
const TerserPlugin = require('terser-webpack-plugin');

const pluginName = 'charts_text_filter';
const manifest = require('./node_modules/ckeditor5/build/ckeditor5-dll.manifest.json');

const config = {
  mode: 'production',
  optimization: {
    minimize: true,
    minimizer: [
      new TerserPlugin({
        terserOptions: {
          format: { comments: false },
          compress: {
            drop_console: true,
          },
        },
        extractComments: false,
      }),
    ],
  },
  entry: path.resolve(
    __dirname,
    'js/ckeditor5_plugins',
    pluginName,
    'src/index.js',
  ),
  output: {
    path: path.resolve(__dirname, 'js/build'),
    filename: `${pluginName}.js`,
    library: ['CKEditor5', pluginName],
    libraryTarget: 'umd',
    libraryExport: 'default',
  },
  plugins: [
    new webpack.DllReferencePlugin({
      manifest,
      scope: 'ckeditor5/src',
      name: 'CKEditor5.dll',
    }),
  ],
  module: {
    rules: [
      {
        test: /\.svg$/,
        use: 'raw-loader',
      },
      {
        test: /\.css$/,
        use: [
          'style-loader',
          {
            loader: 'css-loader',
            options: {
              modules: false,
            },
          },
          'postcss-loader',
        ],
      },
    ],
  },
  resolve: {
    extensions: ['.js'],
  },
};

module.exports = config;
