(function (Drupal) {
  /**
   * Registers a custom AJAX command to insert chart HTML into CKEditor.
   */
  if (Drupal && Drupal.AjaxCommands) {
    Drupal.AjaxCommands.prototype.insertChartCommand = function (
      ajax,
      response,
      status,
    ) {
      // Check if the global insertChart function from our CKEditor plugin exists.
      if (typeof window.insertChart === 'function') {
        window.insertChart(response.chartHtml);
      } else {
        console.error('The insertChart function is not available.');
      }
    };
  }
})(Drupal);
