import { Plugin } from 'ckeditor5/src/core';
import { Widget } from 'ckeditor5/src/widget';
import ChartTextFilterUI from './charttextfilterui';
import ChartTextFilterEditing from './charttextfilterediting';
import InsertChartCommand from './insertchartcommand';

export default class ChartTextFilter extends Plugin {
  static get requires() {
    return [Widget, ChartTextFilterUI, ChartTextFilterEditing];
  }

  static get pluginName() {
    return 'Chart';
  }

  init() {
    console.log('ChartTextFilter plugin init');
    const { editor } = this;

    // Register the command.
    editor.commands.add('insertChart', new InsertChartCommand(editor));

    // Store reference to editor in closure.
    const editorInstance = editor;

    // Define the function directly on window.
    window.insertChart = function (chartHtml) {
      console.log('window.insertChart called with:', chartHtml);

      // Parse the HTML to extract the data-chart-config.
      const parser = new DOMParser();
      const doc = parser.parseFromString(chartHtml, 'text/html');
      const chartElement = doc.querySelector('chart');

      if (chartElement) {
        const config = chartElement.getAttribute('data-chart-config');

        // Insert using the model's chart element.
        editorInstance.model.change((writer) => {
          const chartWidget = writer.createElement('chart', {
            'data-chart-config': config,
          });

          editorInstance.model.insertContent(
            chartWidget,
            editorInstance.model.document.selection,
          );
        });
      }

      // Focus back on the editor.
      editorInstance.editing.view.focus();
    };

    console.log('window.insertChart defined:', typeof window.insertChart);
  }
}
