import { Command } from 'ckeditor5/src/core';

export default class InsertChartCommand extends Command {
  execute() {
    const { editor } = this;
    const dialogUrl = editor.config.get('charts_text_filter.dialogUrl');

    if (!dialogUrl) {
      console.error('Dialog URL not configured');
      return;
    }

    if (typeof Drupal !== 'undefined' && Drupal.ajax) {
      const ajaxSettings = {
        url: dialogUrl,
        dialogType: 'modal',
        dialog: {
          title: 'Configure Chart',
          width: '75%',
          height: 'auto',
        },
      };
      const ajaxObject = Drupal.ajax(ajaxSettings);
      ajaxObject.execute();
    } else {
      console.error('Drupal.ajax not available');
    }
  }

  refresh() {
    this.isEnabled = !this.editor.isReadOnly;
  }
}
