<?php

namespace Drupal\charts_text_filter\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;

/**
 * Controller for opening the chart configuration dialog.
 */
class ChartsDialogController extends ControllerBase {

  /**
   * Returns the chart configuration form.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The current request.
   *
   * @return array
   *   The form render array.
   */
  public function openDialog(Request $request): array {
    // Simply build and return the form. Drupal's AJAX system will handle
    // wrapping it in a modal dialog for the initial request, and the Form API
    // will handle the submission request correctly.
    return $this->formBuilder()->getForm('Drupal\charts_text_filter\Form\ChartConfigForm');
  }

}
