<?php

namespace Drupal\charts_text_filter\Plugin\CKEditor5Plugin;

use Drupal\ckeditor5\Attribute\CKEditor5Plugin;
use Drupal\ckeditor5\Plugin\CKEditor5PluginDefault;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\editor\EditorInterface;
use Drupal\Core\Url;
use Drupal\ckeditor5\Attribute\CKEditor5AspectsOfCKEditor5Plugin;
use Drupal\ckeditor5\Attribute\DrupalAspectsOfCKEditor5Plugin;

/**
 * CKEditor 5 plugin that provides an "Insert Chart" button.
 *
 * @internal
 *   Plugin classes are internal.
 */
#[CKEditor5Plugin(
  id: 'charts_text_filter_button',
  ckeditor5: new CKEditor5AspectsOfCKEditor5Plugin(
    plugins: ['charts_text_filter.Chart'],
  ),
  drupal: new DrupalAspectsOfCKEditor5Plugin(
    label: new TranslatableMarkup('Chart'),
    library: 'charts_text_filter/charts_button',
    admin_library: 'charts_text_filter/admin',
    elements: [
      '<chart>',
      '<chart data-chart-config>',
    ],
    toolbar_items: [
      'insertChart' => [
        'label' => 'Insert Chart',
      ],
    ],
  ),
)]
class ChartButton extends CKEditor5PluginDefault {

  /**
   * {@inheritdoc}
   */
  public function getDynamicPluginConfig(array $static_plugin_config, EditorInterface $editor): array {
    // Generate the dialog URL.
    $url = Url::fromRoute('charts_text_filter.dialog');

    // Return configuration that will be available in CKEditor.
    return [
      'charts_text_filter' => [
        'dialogUrl' => $url->toString(),
      ],
    ];
  }

}
