# Charts Twig

This module allows you to render a chart using Twig. It provides `chart()`
function.

Note that when adding Twig into a View, the necessary charting libraries may be
stripped. The chart will not display until the required JavaScript files are
already present on the page.

This module assumes that the Charts module has been enabled, that at least one
charting provider (e.g., Google Charts, Highcharts) has been enabled, and that
the Charts Default Settings have been configured.


## Requirements

This module requires the following modules:

- [Charts](https://www.drupal.org/project/charts)


## Installation

Install as you would normally install a contributed Drupal module. For further
 information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

1. Enable the module at Administration > Extend.
2. Ensure that your charts default settings have been saved.
3. Add your code into a Twig file and view the result.


## Recommended way of using `chart()`

It is recommended to use the `chart()` function by passing it an array.
This  function accepts a single array (often called an "options object") that
defines the entire chart.
This approach is more flexible and allows for advanced features like multiple
axes.

### Simple Example

Here is a basic example that builds a two-series column chart.

```twig
{% set my_chart = { id: 'my_twig_chart', chart_type: 'column', title: 'The Chart Title'|t, series: [ { title: 'My first series'|t, data: [10, 20, 30], color: 'purple', }, { title: 'My second series'|t, data: [8, 14, 22], }, ], axes: { xaxis: { type: 'chart_xaxis', title: 'X-Axis Label'|t, labels: ['a', 'b', 'c'], } } } %}

{{ chart(my_chart) }}
```

### Advanced Example: Multiple Y-Axes

This example demonstrates a mixed-type chart with two Y-axes. A `line`
series is plotted against a right-side axis, and a `column` series is
plotted against the left-side axis.

```twig
{% set complex_chart = { id: 'performance_chart', chart_type: 'column', title: 'Website Performance'|t, series: [ { title: 'Pageviews (Millions)'|t, data: [1.5, 1.7, 2.0], target_axis: 'yaxis_pageviews', }, { title: 'Load Time (ms)'|t, data: [450, 400, 380], target_axis: 'yaxis_loadtime', chart_type: 'line', }, ], axes: { xaxis: { type: 'chart_xaxis', title: 'Month'|t, labels: ['Jan', 'Feb', 'Mar'], }, yaxis_pageviews: { type: 'chart_yaxis', title: 'Pageviews (M)'|t, }, yaxis_loadtime: { type: 'chart_yaxis', title: 'Load Time (ms)'|t, opposite: true, }, }, raw_options: { subtitle: { text: 'A subtitle from raw options'|t } } } %}

{{ chart(complex_chart) }}
```

## Legacy way of using `chart()`

For backwards compatibility the `chart()` function still accepts a long list of
arguments.

```twig
{% set title = 'The Chart Title' %} {% set data = [10, 20, 30] %} {% set data2 = [8, 14, 22] %} {% set series = { 'my_first_series' : { 'title' : 'My first series', 'data' : data, 'color': 'purple' }, 'my_second_series' : { 'title' : 'My second series', 'data' : data2 } } %} {% set xaxis = { 'title' : 'X-Axis Label', 'labels' : ['a', 'b', 'c'] } %}

{{ chart('my_twig_chart', 'column', title, series, xaxis, [], []) }}
```

## Translation

If you plan to use translation on your site, you should use the `|t` filter
for any user-facing strings, as shown in the examples above.

See: https://www.drupal.org/docs/8/api/translation-api/overview

## Maintainers

- Daniel Cothran - [andileco](https://www.drupal.org/u/andileco)
- Nia Kathoni - [nikathone](https://www.drupal.org/u/nikathone)
