<?php

declare(strict_types=1);

namespace Drupal\chrome_ai_summarize\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Block\Attribute\Block;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Provides a block that summarizes page content using Chrome AI.
 */
#[Block(
  id: "chrome_ai_summarize_block",
  admin_label: new TranslatableMarkup("Chrome AI Summarize"),
  category: new TranslatableMarkup("AI")
)]
class ChromeAiSummarizeBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build(): array {
    return [
      '#type' => 'container',
      '#attributes' => [
        'class' => ['chrome-ai-summarize-wrapper'],
      ],
      'button' => [
        '#type' => 'button',
        '#value' => $this->t('Summarize This Page'),
        '#attributes' => [
          'class' => [
            'chrome-ai-summarize-button',
            'js-chrome-ai-summarize-button',
          ],
        ],
      ],
      'summary' => [
        '#type' => 'container',
        '#attributes' => [
          'class' => ['chrome-ai-summarize-summary'],
          'aria-live' => 'polite',
          'role' => 'status',
        ],
      ],
      '#attached' => [
        'library' => [
          'chrome_ai_summarize/chrome_ai_summarize',
        ],
      ],
    ];
  }

}
