# Chrome AI Summarize

A Drupal 11 module that provides on-device content summarization using Chrome's built-in AI Summarizer API. Summaries are generated locally in the browser—no data is sent to external servers.

## Requirements

- **Drupal**: 11 or higher
- **Browser**: Google Chrome 138+ (Dev/Canary channel)
- **Chrome Flag**: Enable `chrome://flags/#optimization-guide-on-device-model` (set to "Enabled BypassPerfRequirement")

### Enabling Chrome AI

1. Navigate to `chrome://flags/#optimization-guide-on-device-model`
2. Set to **"Enabled BypassPerfRequirement"**
3. Restart Chrome
4. AI model (~1.5GB) downloads automatically on first use

**Note**: This API is experimental and may change.

## Installation

```bash
drush en chrome_ai_summarize -y
drush cache:rebuild
```

## Usage

1. Place the **"Chrome AI Summarize"** block via Structure > Block layout
2. Visit any page with the block
3. Click **"Summarize This Page"**
4. View the AI-generated summary in real-time

The block automatically hides in unsupported browsers.

## Features

- On-device AI processing (privacy-focused)
- Real-time streaming output
- Multi-language support (en, es, ja)
- Download progress feedback
- Smart content extraction (targets `#main`)

## Troubleshooting

- **Block not appearing**: Verify Chrome 138+, flag enabled, cache cleared
- **Summarization fails**: Ensure AI model downloaded, check browser console
- **Model download issues**: Check internet connection and disk space (~1.5GB)
