<?php

declare(strict_types=1);

namespace Drupal\chromeless\EventSubscriber;

use Drupal\chromeless\ChromelessTempstore;

use Drupal\Core\Render\PageDisplayVariantSelectionEvent;
use Drupal\Core\Render\RenderEvents;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Selects the simple page display if requested.
 *
 * Copyright (C) 2025  Library Solutions, LLC (et al.).
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * @see \Drupal\Core\Render\MainContent\HtmlRenderer::prepare()
 */
final class PageDisplayVariantSubscriber implements EventSubscriberInterface {

  /**
   * The chromeless tempstore.
   *
   * @var \Drupal\chromeless\ChromelessTempstore
   */
  private readonly ChromelessTempstore $chromelessTempstore;

  /**
   * Constructs a PageDisplayVariantSubscriber object.
   *
   * @param \Drupal\chromeless\ChromelessTempstore $chromeless_tempstore
   *   The chromeless tempstore.
   */
  public function __construct(ChromelessTempstore $chromeless_tempstore) {
    $this->chromelessTempstore = $chromeless_tempstore;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events[RenderEvents::SELECT_PAGE_DISPLAY_VARIANT] = 'onSelectPageDisplayVariant';

    return $events;
  }

  /**
   * Selects the simple page display if requested.
   *
   * @param \Drupal\Core\Render\PageDisplayVariantSelectionEvent $event
   *   The event to process.
   */
  public function onSelectPageDisplayVariant(PageDisplayVariantSelectionEvent $event) {
    if ($this->chromelessTempstore->isActive) {
      $event->setPluginId('chromeless_page');
    }
  }

}
