<?php

declare(strict_types=1);

namespace Drupal\chromeless_test;

use Drupal\Component\Utility\Random;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

/**
 * Override container parameters under test.
 *
 * Copyright (C) 2025  Library Solutions, LLC (et al.).
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
final class ChromelessTestServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function register(ContainerBuilder $container) {
    $random = new Random();

    $container->setParameter('chromeless.query.active', $random->machineName(unique: TRUE));
    $container->setParameter('chromeless.query.title', $random->machineName(unique: TRUE));
  }

}
