<?php

declare(strict_types=1);

namespace Drupal\chromium_tool\Service;

use Drupal\Core\Config\ConfigFactoryInterface;
use HeadlessChromium\BrowserFactory;

/**
 * Factory service for creating chrome-php BrowserFactory instances.
 */
final class ChromiumBrowserFactory {

  /**
   * The Drupal config factory.
   */
  private ConfigFactoryInterface $configFactory;

  public function __construct(ConfigFactoryInterface $configFactory) {
    $this->configFactory = $configFactory;
  }

  /**
   * Create and return a BrowserFactory using configured executable path.
   */
  public function create(): BrowserFactory {
    $config = $this->configFactory->get('chromium_tool.settings');
    $executablePath = (string) ($config->get('chrome_executable_path') ?? '');

    // If not set, create without path (chrome-php/chrome will try defaults).
    if ($executablePath === '') {
      return new BrowserFactory();
    }

    return new BrowserFactory($executablePath);
  }

}
