<?php

namespace Drupal\cilogon_globus_auth\Form;

use Drupal\openid_connect\Form\OpenIDConnectAccountsForm;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Custom form to display the identity provider name instead of the OpenID Connect ID.
 */
class OSPOpenIDConnectAccountsForm extends OpenIDConnectAccountsForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, ?AccountInterface $user = NULL): array {
    // Build the form using the parent method.
    $form = parent::buildForm($form, $form_state, $user);

    // Loop through each provider’s fieldset.
    foreach ($form as $key => &$element) {
      // Check that this is a fieldset (each provider’s container).
      if (is_array($element) && isset($element['#type']) && $element['#type'] === 'fieldset') {
        // The provider’s label is in the fieldset title, e.g. "Provider: Google".
        // Remove the "Provider: " prefix to get just the provider name.
        if (isset($element['#title'])) {
          $provider_label = preg_replace('/^Provider:\s*/', '', $element['#title']);
        }
        else {
          $provider_label = $key;
        }

        // If the fieldset has a 'status' element with markup,
        // and it indicates that the account is connected,
        // update the markup to display the provider name.
        if (isset($element['status']['#markup']) && strpos($element['status']['#markup'], 'Connected as') !== FALSE) {
          $element['status']['#markup'] = $this->t('Connected to @provider', [
            '@provider' => $provider_label,
          ]);
        }
      }
    }

    return $form;
  }

}
