<?php

namespace Drupal\cilogon_globus_auth;

use Drupal\openid_connect\OpenIDConnectSession;

/**
 * Custom session class that adds support for transfer tokens.
 */
class OSPOpenIDConnectSession extends OpenIDConnectSession {

  /**
   * Save the extra transfer token information.
   *
   * @param array $transfer_tokens
   *   An associative array with keys:
   *   - transfer_access_token: The transfer access token.
   *   - transfer_scope: The scope for the transfer token.
   *   - transfer_expire: The expiration time (in seconds or timestamp).
   */
  public function saveTransferTokens(array $transfer_tokens): void {
    // Save these tokens under a custom session key.
    $this->session->set('openid_connect_transfer', $transfer_tokens);
  }

  /**
   * Retrieve the extra transfer token information.
   *
   * @param bool $clear
   *   (Optional) Whether to clear the token after retrieval.
   *
   * @return array|null
   *   The transfer token information, or NULL if not available.
   */
  public function retrieveTransferTokens(bool $clear = FALSE): ?array {
    $tokens = $this->session->get('openid_connect_transfer');
    if ($clear && $tokens) {
      $this->session->remove('openid_connect_transfer');
    }
    return is_array($tokens) ? $tokens : NULL;
  }
}
