# CILogon and Globus Auth (OpenID Connect)

## Overview
This Drupal 10 module extends the OpenID Connect module by providing two client plugins and login UI helpers:

- CILogon (OSP): `ospclscigw`
- Globus Auth (OSP): `ospgascigw`

It also adds a site settings page to customize login button text and contextual help, and improves the Connected Accounts UI by showing the human‑readable IdP name.

Useful links:
- OpenID Connect module: https://www.drupal.org/project/openid_connect
- CILogon: https://www.cilogon.org/
- Globus: https://www.globus.org/

## Features
- OpenID Connect clients for CILogon and Globus Auth with sensible defaults (endpoints and scopes).
- Optional integration with the Key module for storing client secrets securely.
- Login form enhancements:
  - Configurable button text (global default + per‑client overrides).
  - Configurable help text (global + per‑client) rendered on the login page.
- Connected Accounts page shows “Connected to {IdP}” using values from the IdP’s userinfo claims.

## Requirements
- Drupal: ^10
- OpenID Connect: `drupal/openid_connect:^3.0@alpha`
- Recommended: `drupal/key` (to store client secrets); `drupal/externalauth` is pulled in by OpenID Connect.

## Installation
Option A — local/custom module:
- Place this module in `web/modules/custom/cilogon_globus_auth`.

Option B — Composer path repository (if desired):
- Add a path repository to your project’s `composer.json`, then `composer require drupal/cilogon_globus_auth` targeting that path.

Enable the module:
- `drush en cilogon_globus_auth`

The install step seeds two OpenID Connect client configurations for the plugin IDs above, with endpoints and default scopes but empty client credentials. Both clients are disabled until you configure them.

## Configuration
1) Configure OpenID Connect clients
- Navigate to: Configuration → People → OpenID Connect.
- Add or edit the clients using plugins “CILogon (OSP)” and “Globus Auth (OSP)”.
- Fill in Client ID and Client Secret from your provider application.
  - If the Key module is enabled, “Client Secret” can reference a Key of type “authentication”.
- Endpoints are pre‑filled and can be adjusted if needed:
  - CILogon: authorize `https://cilogon.org/authorize`, token `https://cilogon.org/oauth2/token`, userinfo `https://cilogon.org/oauth2/userinfo`.
  - Globus: authorize `https://auth.globus.org/v2/oauth2/authorize`, token `https://auth.globus.org/v2/oauth2/token`, userinfo `https://auth.globus.org/v2/oauth2/userinfo`.
- Scopes:
  - CILogon default: `email,openid,profile,org.cilogon.userinfo`.
  - Globus default: `openid email`.
- Redirect URI: use the value shown on the OpenID Connect client edit page (pattern is typically `/openid-connect/{plugin_id}/callback`). Register this URI with your provider.

2) Customize login UI text
- Navigate to: Configuration → People → CILogon/Globus Auth (`/admin/config/people/cilogon-globus-auth`).
- Default button text template: use `@client_title` to inject the client label (example: “Log in with @client_title”).
- Optional per‑client overrides for button text and help text.
- Help text supports site text formats and renders on the login page beneath the provider buttons.

## Behavior Details
- Connected Accounts UI: The user page “Connected Accounts” displays “Connected to {IdP}”. The module stores the IdP display name in the authmap from userinfo claims `idp_name` (CILogon) or `identity_provider_display_name` (Globus), when available.

## Notes and Limitations
- OpenID Connect v3.x (alpha) API is used; keep versions in sync.
- Ensure proper redirect URIs are registered with your providers.

## Maintenance
- Clear caches after install or configuration changes: `drush cr`.
- If button text or help text does not update immediately, check render cache; the module tags the settings for invalidation.

## License
GPL-2.0-or-later (matches Drupal module conventions).
