<?php

namespace Drupal\cilogon_globus_auth\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Alters routes to disable public user registration UI.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Make hiding the public user registration route configurable.
    $config = \Drupal::config('cilogon_globus_auth.settings');
    $hide_register = (bool) $config->get('hide_user_register');
    if ($hide_register && ($route = $collection->get('user.register'))) {
      // Disable access so the "Create new account" link disappears, while
      // SSO can still provision accounts via ExternalAuth.
      $route->setRequirement('_access', 'FALSE');
    }
  }

}
