/**
 * @file Contains shims to avoid breaking older versions of CKEditor 5.
 */

import type { EditingView, ViewEditableElement } from 'ckeditor5/src/engine';
import { enablePlaceholder, enableViewPlaceholder } from 'ckeditor5/src/engine';
import { ViewModel, Model } from 'ckeditor5/src/ui';
import { ckMajorVersion } from './bootstrapaccordionutils';

// cSpell:ignore editableelement

/** 
 * Older versions of CKEditor 5 expect the export to be named `Model` rather
 * than `ViewModel`. See https://github.com/ckeditor/ckeditor5/issues/15661
 *
 * This shim allows CKEditor 5 Bootstrap Accordion to retain compatibility with
 * Drupal 10.2 and earlier.
 */
export const UiViewModel = typeof ViewModel === 'undefined' ? Model : ViewModel;

/**
 * Older versions of CKEditor 5 handled placeholders differently.
 *
 * This shim allows CKEditor 5 Bootstrap Accordion to support placeholders in
 * Drupal 10.1 and earlier.
 *
 * @param placeholderOptions
 *   The placeholder options to be passed through to the `enablePlaceholder`
 *   library call.
 */
export function engineEnablePlaceholder(placeholderOptions: {
  view: EditingView;
  element: ViewEditableElement;
  isDirectHost?: boolean;
  keepOnFocus?: boolean;
  text?: string;
}) {
  if (ckMajorVersion < 39) {
    // Uses legacy `text` option in older versions of CKEditor 5.
    placeholderOptions.text = placeholderOptions.element.placeholder;
  }
  (enableViewPlaceholder || enablePlaceholder)(placeholderOptions);
}
