/**
 * @file registers the quote toolbar button and binds functionality to it.
 * eslint-disable import/no-relative-packages
 */
/* eslint-disable import/no-relative-packages, import/no-extraneous-dependencies */

import { Plugin } from 'ckeditor5/src/core';
import { ButtonView } from 'ckeditor5/src/ui';
import icon from '../../../../icons/quote.svg';

export default class InlineQuoteUI extends Plugin {
  init() {
    const { editor } = this;
    const { t } = editor;

    // This will register the quote toolbar button.
    editor.ui.componentFactory.add('toggleInlineQuote', (locale) => {
      const command = editor.commands.get('toggleInlineQuote');
      const buttonView = new ButtonView(locale);

      // Create the toolbar button.
      buttonView.set({
        label: t('Inline quote'),
        icon,
        tooltip: true,
        isToggleable: true,
      });

      // Bind the state of the button to the command.
      buttonView.bind('isOn', 'isEnabled').to(command, 'value', 'isEnabled');

      // Execute the command when the button is clicked (executed).
      this.listenTo(buttonView, 'execute', () => {
        editor.execute('toggleInlineQuote');
        editor.editing.view.focus();
      });

      return buttonView;
    });
  }
}
