(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["CKEditor5"] = factory();
	else
		root["CKEditor5"] = root["CKEditor5"] || {}, root["CKEditor5"]["inlineQuote"] = factory();
})(globalThis, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "ckeditor5/src/core.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = (__webpack_require__("dll-reference CKEditor5.dll"))("./src/core.js");

/***/ }),

/***/ "ckeditor5/src/ui.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = (__webpack_require__("dll-reference CKEditor5.dll"))("./src/ui.js");

/***/ }),

/***/ "ckeditor5/src/widget.js":
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = (__webpack_require__("dll-reference CKEditor5.dll"))("./src/widget.js");

/***/ }),

/***/ "dll-reference CKEditor5.dll":
/***/ ((module) => {

"use strict";
module.exports = CKEditor5.dll;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ src)
});

// EXTERNAL MODULE: delegated ./core.js from dll-reference CKEditor5.dll
var delegated_corefrom_dll_reference_CKEditor5 = __webpack_require__("ckeditor5/src/core.js");
// EXTERNAL MODULE: delegated ./widget.js from dll-reference CKEditor5.dll
var delegated_widgetfrom_dll_reference_CKEditor5 = __webpack_require__("ckeditor5/src/widget.js");
;// ./js/ckeditor5_plugins/inlineQuote/src/attributecommand.js
/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/* eslint-disable import/no-extraneous-dependencies */

/**
 * An extension of the base {@link module:core/command~Command} class, which provides utilities for a command
 * that toggles a single attribute on a text or an element.
 *
 * `AttributeCommand` uses {@link module:engine/model/document~Document#selection}
 * to decide which nodes (if any) should be changed, and applies or removes the attribute from them.
 *
 * The command checks the {@link module:engine/model/model~Model#schema} to decide if it can be enabled
 * for the current selection and to which nodes the attribute can be applied.
 */
class AttributeCommand extends delegated_corefrom_dll_reference_CKEditor5.Command {
  /**
   * @param attributeKey Attribute that will be set by the command.
   */
  constructor(editor, attributeKey) {
    super(editor);
    this.attributeKey = attributeKey;
  }

  /**
   * Updates the command's {@link #value} and {@link #isEnabled} based on the current selection.
   */
  refresh() {
    const { model } = this.editor;
    const doc = model.document;
    this.value = this._getValueFromFirstAllowedNode();
    this.isEnabled = model.schema.checkAttributeInSelection(
      doc.selection,
      this.attributeKey,
    );
  }

  /**
   * Executes the command &ndash; applies the attribute to the selection or removes it from the selection.
   *
   * If the command is active (`value == true`), it will remove attributes. Otherwise, it will set attributes.
   *
   * The execution result differs, depending on the {@link module:engine/model/document~Document#selection}:
   *
   * * If the selection is on a range, the command applies the attribute to all nodes in that range
   * (if they are allowed to have this attribute by the {@link module:engine/model/schema~Schema schema}).
   * * If the selection is collapsed in a non-empty node, the command applies the attribute to the
   * {@link module:engine/model/document~Document#selection} itself (note that typed characters copy attributes from the selection).
   * * If the selection is collapsed in an empty node, the command applies the attribute to the parent node of the selection (note
   * that the selection inherits all attributes from a node if it is in an empty node).
   *
   * @fires execute
   * @param options Command options.
   * @param options.forceValue If set, it will force the command behavior. If `true`,
   * the command will apply the attribute, otherwise the command will remove the attribute.
   * If not set, the command will look for its current value to decide what it should do.
   */
  execute(options = {}) {
    const { model } = this.editor;
    const doc = model.document;
    const { selection } = doc;
    const value =
      options.forceValue === undefined ? !this.value : options.forceValue;
    model.change((writer) => {
      if (selection.isCollapsed) {
        if (value) {
          writer.setSelectionAttribute(this.attributeKey, true);
        } else {
          writer.removeSelectionAttribute(this.attributeKey);
        }
      } else {
        const ranges = model.schema.getValidRanges(
          selection.getRanges(),
          this.attributeKey,
        );
        // eslint-disable-next-line no-restricted-syntax
        for (const range of ranges) {
          if (value) {
            writer.setAttribute(this.attributeKey, value, range);
          } else {
            writer.removeAttribute(this.attributeKey, range);
          }
        }
      }
    });
  }

  /**
   * Checks the attribute value of the first node in the selection that allows the attribute.
   * For the collapsed selection returns the selection attribute.
   *
   * @return The attribute value.
   */
  _getValueFromFirstAllowedNode() {
    const { model } = this.editor;
    const { schema } = model;
    const { selection } = model.document;
    if (selection.isCollapsed) {
      return selection.hasAttribute(this.attributeKey);
    }
    // eslint-disable-next-line no-restricted-syntax
    for (const range of selection.getRanges()) {
      // eslint-disable-next-line no-restricted-syntax
      for (const item of range.getItems()) {
        if (schema.checkAttribute(item, this.attributeKey)) {
          return item.hasAttribute(this.attributeKey);
        }
      }
    }
    return false;
  }
}

;// ./js/ckeditor5_plugins/inlineQuote/src/inline_quote-editing.js
/* eslint-disable import/no-extraneous-dependencies */





/**
 * CKEditor 5 plugins do not work directly with the DOM. They are defined as
 * plugin-specific data models that are then converted to markup that
 * is inserted in the DOM.
 *
 * CKEditor 5 internally interacts with quote as this model:
 * <quote></quote>
 *
 * Which is converted for the browser/user as this markup
 * <q></q>
 *
 * This file has the logic for defining the quote model, and for how it is
 * converted to standard DOM markup.
 */
class InlineQuoteEditing extends delegated_corefrom_dll_reference_CKEditor5.Plugin {
  static get requires() {
    return [delegated_widgetfrom_dll_reference_CKEditor5.Widget];
  }

  init() {
    this._defineSchema();
    this._defineConverters();
    this.editor.commands.add(
      'toggleInlineQuote',
      new AttributeCommand(this.editor, 'inline_quote'),
    );
  }

  /*
   * @todo
   *
   * The logic in _defineConverters() will determine how this is converted to
   * markup.
   */
  _defineSchema() {
    // Schemas are registered via the central `editor` object.
    const { schema } = this.editor.model;

    // Extend the text node's schema to accept the abbreviation attribute.
    schema.extend('$text', {
      allowAttributes: ['inline_quote'],
    });
    schema.setAttributeProperties('inline_quote', {
      isFormatting: true,
      copyOnEnter: true,
    });
  }

  /**
   * Converters determine how CKEditor 5 models are converted into markup and
   * vice-versa.
   */
  _defineConverters() {
    // Converters are registered via the central editor object.
    const { conversion } = this.editor;

    // Build converter from model to view for data and editing pipelines.
    conversion.attributeToElement({
      model: 'inline_quote',
      view: 'q',
    });
  }
}

// EXTERNAL MODULE: delegated ./ui.js from dll-reference CKEditor5.dll
var delegated_uifrom_dll_reference_CKEditor5 = __webpack_require__("ckeditor5/src/ui.js");
;// ./icons/quote.svg
/* harmony default export */ const quote = ("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path d=\"M0 1v16.981h4v5.019l7-5.019h13v-16.981h-24zm12 8.028c0 2.337-1.529 3.91-3.684 4.335l-.406-.87c.996-.375 1.637-1.587 1.637-2.493h-1.547v-4h4v3.028zm5 0c0 2.337-1.529 3.91-3.684 4.335l-.406-.87c.996-.375 1.637-1.587 1.637-2.493h-1.547v-4h4v3.028z\"/></svg>");
;// ./js/ckeditor5_plugins/inlineQuote/src/inline_quote-ui.js
/**
 * @file registers the quote toolbar button and binds functionality to it.
 * eslint-disable import/no-relative-packages
 */
/* eslint-disable import/no-relative-packages, import/no-extraneous-dependencies */





class InlineQuoteUI extends delegated_corefrom_dll_reference_CKEditor5.Plugin {
  init() {
    const { editor } = this;
    const { t } = editor;

    // This will register the quote toolbar button.
    editor.ui.componentFactory.add('toggleInlineQuote', (locale) => {
      const command = editor.commands.get('toggleInlineQuote');
      const buttonView = new delegated_uifrom_dll_reference_CKEditor5.ButtonView(locale);

      // Create the toolbar button.
      buttonView.set({
        label: t('Inline quote'),
        icon: quote,
        tooltip: true,
        isToggleable: true,
      });

      // Bind the state of the button to the command.
      buttonView.bind('isOn', 'isEnabled').to(command, 'value', 'isEnabled');

      // Execute the command when the button is clicked (executed).
      this.listenTo(buttonView, 'execute', () => {
        editor.execute('toggleInlineQuote');
        editor.editing.view.focus();
      });

      return buttonView;
    });
  }
}

;// ./js/ckeditor5_plugins/inlineQuote/src/inline_quote.js
/**
 * @file This is what CKEditor refers to as a master (glue) plugin. Its role is
 * just to load the “editing” and “UI” components of this Plugin. Those
 * components could be included in this file, but
 *
 * I.e, this file's purpose is to integrate all the separate parts of the plugin
 * before it's made discoverable via index.js.
 */
/* eslint-disable import/no-extraneous-dependencies */
// cSpell:ignore quoteediting quoteui

// The contents of QuoteUI and Quote editing could be included in this
// file, but it is recommended to separate these concerns in different files.




class InlineQuote extends delegated_corefrom_dll_reference_CKEditor5.Plugin {
  // Note that QuoteEditing and QuoteUI also extend `Plugin`, but these
  // are not seen as individual plugins by CKEditor 5. CKEditor 5 will only
  // discover the plugins explicitly exported in index.js.
  static get requires() {
    return [InlineQuoteEditing, InlineQuoteUI];
  }
}

;// ./js/ckeditor5_plugins/inlineQuote/src/index.js
/**
 * @file The build process always expects an index.js file. Anything exported
 * here will be recognized by CKEditor 5 as an available plugin. Multiple
 * plugins can be exported in this one file.
 *
 * I.e. this file's purpose is to make plugin(s) discoverable.
 */



/* harmony default export */ const src = ({
  InlineQuote: InlineQuote,
});

})();

__webpack_exports__ = __webpack_exports__["default"];
/******/ 	return __webpack_exports__;
/******/ })()
;
});