/* eslint-disable import/no-extraneous-dependencies */

import { Plugin } from 'ckeditor5/src/core';
import { Widget } from 'ckeditor5/src/widget';
import AttributeCommand from './attributecommand';

/**
 * CKEditor 5 plugins do not work directly with the DOM. They are defined as
 * plugin-specific data models that are then converted to markup that
 * is inserted in the DOM.
 *
 * CKEditor 5 internally interacts with quote as this model:
 * <quote></quote>
 *
 * Which is converted for the browser/user as this markup
 * <q></q>
 *
 * This file has the logic for defining the quote model, and for how it is
 * converted to standard DOM markup.
 */
export default class InlineQuoteEditing extends Plugin {
  static get requires() {
    return [Widget];
  }

  init() {
    this._defineSchema();
    this._defineConverters();
    this.editor.commands.add(
      'toggleInlineQuote',
      new AttributeCommand(this.editor, 'inline_quote'),
    );
  }

  /*
   * @todo
   *
   * The logic in _defineConverters() will determine how this is converted to
   * markup.
   */
  _defineSchema() {
    // Schemas are registered via the central `editor` object.
    const { schema } = this.editor.model;

    // Extend the text node's schema to accept the abbreviation attribute.
    schema.extend('$text', {
      allowAttributes: ['inline_quote'],
    });
    schema.setAttributeProperties('inline_quote', {
      isFormatting: true,
      copyOnEnter: true,
    });
  }

  /**
   * Converters determine how CKEditor 5 models are converted into markup and
   * vice-versa.
   */
  _defineConverters() {
    // Converters are registered via the central editor object.
    const { conversion } = this.editor;

    // Build converter from model to view for data and editing pipelines.
    conversion.attributeToElement({
      model: 'inline_quote',
      view: 'q',
    });
  }
}
