/**
 * @file registers the tereo toolbar button and binds functionality to it.
 * eslint-disable import/no-relative-packages
 */
/* eslint-disable import/no-relative-packages, import/no-extraneous-dependencies */

import { Plugin } from "ckeditor5/src/core";
import { ButtonView } from "ckeditor5/src/ui";
import icon from "../../../../icons/noun-koru-2927216.svg";

export default class InlineTereoUI extends Plugin {
  init() {
    const { editor } = this;

    // This will register the tereo toolbar button.
    editor.ui.componentFactory.add("toggleInlineTereo", (locale) => {
      const command = editor.commands.get("toggleInlineTereo");
      const buttonView = new ButtonView(locale);

      // Create the toolbar button.
      buttonView.set({
        label: editor.t("te reo Māori"),
        icon,
        tooltip: true,
        isToggleable: true,
      });

      // Bind the state of the button to the command.
      buttonView.bind("isOn", "isEnabled").to(command, "value", "isEnabled");

      // Execute the command when the button is clicked (executed).
      this.listenTo(buttonView, "execute", () => {
        editor.execute("toggleInlineTereo");
        editor.editing.view.focus();
      });

      return buttonView;
    });
  }
}
