/**
 * ckeditor-scroll-fix.js
 * Fixes CKEditor 5 focus lock on page scroll.
 */
(function (Drupal, once) {
  'use strict';

  Drupal.behaviors.ckeditor5ScrollFix = {
    attach: function (context) {
      once('ckeditor5-scroll-fix', 'body', context).forEach(() => {
        let timer = null;
        let lastTrigger = 0;

        window.addEventListener('scroll', () => {
          if (timer || Date.now() - lastTrigger < 150) return;
          timer = setTimeout(() => timer = null, 100);

          const active = document.activeElement;
          const inEditor = active?.closest?.('.ck-editor__editable');
          if (!inEditor) return;

          const editor = active.closest('.ck-editor');
          const rect = editor.getBoundingClientRect();
          const mouseEvent = window.event;
          const mouseInEditor = mouseEvent && (
            mouseEvent.clientX >= rect.left &&
            mouseEvent.clientX <= rect.right &&
            mouseEvent.clientY >= rect.top &&
            mouseEvent.clientY <= rect.bottom
          );

          if (mouseInEditor) return;

          // Force blur + simulate real click
          active.blur();

          const safe = document.querySelector('main, .layout-container, article, .region-content') || document.body;
          const x = rect.left + 20;
          const y = rect.top + 20;

          ['mousedown', 'mouseup', 'click'].forEach(type => {
            const ev = new MouseEvent(type, {
              bubbles: true,
              cancelable: true,
              clientX: x,
              clientY: y,
              view: window
            });
            safe.dispatchEvent(ev);
          });

          setTimeout(() => document.body.focus(), 10);
          lastTrigger = Date.now();
        }, { passive: true });
      });
    }
  };

})(Drupal, once);
