/**
 * ckeditor-scroll-fix.js
 * Fixes CKEditor 5 focus lock on page scroll, with mobile intent detection.
 */
(function (Drupal, once) {
  'use strict';

  Drupal.behaviors.ckeditor5ScrollFix = {
    attach: function (context) {
      once('ckeditor5-scroll-fix', 'body', context).forEach(() => {
        let timer = null;
        let lastTrigger = 0;
        let intentInputTimeout = null;  // 新增：意图输入标志（timeout ID）

        // 新增：监听编辑器点击/触摸，设置意图输入标志
        document.addEventListener('mousedown', handleIntentInput, true);  // 捕获阶段
        document.addEventListener('touchstart', handleIntentInput, true);

        function handleIntentInput(e) {
          const editable = e.target.closest('.ck-editor__editable');
          if (editable) {
            console.log('User intent: clicking editor for input');  // 可选日志
            // 设置 1s 超时，忽略后续被动滚动
            clearTimeout(intentInputTimeout);
            intentInputTimeout = setTimeout(() => {
              intentInputTimeout = null;
              console.log('Input intent expired');  // 可选
            }, 1000);  // 调整超时：500ms-2s，根据测试
          }
        }

        window.addEventListener('scroll', () => {
          if (timer || Date.now() - lastTrigger < 150) return;
          timer = setTimeout(() => timer = null, 100);

          const active = document.activeElement;
          const inEditor = active?.closest?.('.ck-editor__editable');
          if (!inEditor) return;

          // 新增：如果意图输入中，忽略滚动（被动键盘弹出）
          if (intentInputTimeout) {
            console.log('Ignoring scroll: user intends to input');  // 可选
            return;
          }

          const editor = active.closest('.ck-editor');
          const rect = editor.getBoundingClientRect();
          const mouseEvent = window.event;
          const mouseInEditor = mouseEvent && (
            mouseEvent.clientX >= rect.left &&
            mouseEvent.clientX <= rect.right &&
            mouseEvent.clientY >= rect.top &&
            mouseEvent.clientY <= rect.bottom
          );

          if (mouseInEditor) return;

          // 强制夺回焦点
          active.blur();

          const safe = document.querySelector('main, .layout-container, article, .region-content') || document.body;
          const x = rect.left + 20;
          const y = rect.top + 20;

          ['mousedown', 'mouseup', 'click'].forEach(type => {
            const ev = new MouseEvent(type, {
              bubbles: true,
              cancelable: true,
              clientX: x,
              clientY: y,
              view: window
            });
            safe.dispatchEvent(ev);
          });

          setTimeout(() => document.body.focus(), 10);
          lastTrigger = Date.now();
        }, { passive: true });
      });
    }
  };

})(Drupal, once);
