# CKEditor 5 Shortcut Override

## Overview

This Drupal module allows administrators to override the CKEditor 5 keyboard shortcut Opt+0 (or Alt+0 on Windows),
which normally opens the CKEditor accessibility help popup. On macOS systems, this shortcut conflicts with the system
input for the right square bracket (]) when using a French keyboard layout.

## Problem Solved

On macOS systems using a French locale, pressing Option + 0 is intended to insert a right square bracket (]).  However,
CKEditor 5 intercepts this combination and opens its Accessibility Help dialog instead.

This module resolves that issue by allowing users to disable the accessibility help shortcut, so that Option + 0
(or Alt + 0 on Windows) correctly produces the intended character.

## Features

	•	Disables or overrides the CKEditor 5 accessibility help (Alt/Opt + 0) shortcut.
	•	Restores normal typing behavior for the right square bracket on macOS with French keyboards.
	•	Provides an administrative setting to enable or disable the override.

## Installation

	1.	Place the module in your modules/custom/ directory.
	2.	Enable the module using Drush: `drush en ckeditor5_shortcut_override
	3.	Configure the module at:

Admin → Configuration → Content authoring → CKEditor 5 Shortcut Override

## Configuration

Visit:

`/admin/config/content/ckeditor5-shortcut-override`

From there, you can enable or disable the shortcut override functionality.

## Requirements

- CKEditor 5 core module (included with Drupal 10+)

