<?php

namespace Drupal\ckeditor5_shortcut_override\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure CKEditor 5 Shortcut Override settings for this site.
 */
class ShortcutOverrideConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ckeditor5_shortcut_override_config_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['ckeditor5_shortcut_override.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('ckeditor5_shortcut_override.settings');

    $form['enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Disable the CKEditor accessibility popup'),
      '#description' => $this->t('When enabled, Alt+0 (Opt+0 on macOS) will not open the Accessibility Help popup in CKEditor, allowing you to type it in the text field.'),
      '#default_value' => $config->get('enabled'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('ckeditor5_shortcut_override.settings')
      ->set('enabled', $form_state->getValue('enabled'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
