<?php

declare(strict_types=1);

namespace Drupal\ckeditor5_spoiler\Plugin\Filter;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\filter\Attribute\Filter;
use Drupal\filter\FilterProcessResult;
use Drupal\filter\Plugin\FilterBase;
use Drupal\filter\Plugin\FilterInterface;

/**
 * Provides a filter to attach spoiler library for frontend display.
 */
#[Filter(
  id: 'filter_spoiler',
  title: new TranslatableMarkup('Spoiler support'),
  type: FilterInterface::TYPE_TRANSFORM_IRREVERSIBLE,
  description: new TranslatableMarkup('Adds necessary JavaScript and CSS for spoiler functionality on the frontend.'),
)]
class FilterSpoiler extends FilterBase {

  /**
   * {@inheritdoc}
   */
  public function process($text, $langcode) {
    $result = new FilterProcessResult($text);

    if ($this->hasSpoilerMarkup($text)) {
      $result->addAttachments([
        'library' => [
          'ckeditor5_spoiler/spoiler.for.users',
        ],
      ]);
    }

    return $result;
  }

  /**
   * Checks if the text contains spoiler markup.
   *
   * @param string $text
   *   The text to check.
   *
   * @return bool
   *   TRUE if spoiler markup is found, FALSE otherwise.
   */
  protected function hasSpoilerMarkup(string $text): bool {
    return str_contains($text, 'spoiler');
  }

}
