((Drupal, once) => {
  Drupal.behaviors.ckeditorSpoiler = {
    attach(context) {
      const spoilerTitles = document.querySelectorAll('div.spoiler-title');
      once('spoiler-title', spoilerTitles, context).forEach((element) => {
        element.addEventListener('click', function () {
          const iconElement = this.querySelector('.show-icon, .hide-icon');
          if (iconElement) {
            iconElement.classList.toggle('show-icon');
            iconElement.classList.toggle('hide-icon');
          }
          const nextSibling = this.nextElementSibling;
          if (nextSibling) {
            nextSibling.style.display =
              nextSibling.style.display === 'none' ? '' : 'none';
          }
        });
      });
    },
  };
})(Drupal, once);
