(function () {
  // Get CKEditor Plugin base class from Drupal’s global CKEditor5 loader
  const Plugin = window.CKEditor5.core.Plugin;
  const elements = ['table', 'thead', 'tbody', 'tfoot', 'tr', 'td', 'th', 'caption'];

  class CKEditor5TableFixPlugin extends Plugin {
    static get pluginName() {
      return 'ckeditor5_table_fix_plugin';
    }

    init() {
      const editor = this.editor;
      if (!editor) {
        console.error('Editor is undefined in init()');
        return;
      }

      // Register all table-related elements.
      editor.model.schema.register('table', {
        // Behave like a standard block element (paragraph, heading, etc.),
        // so tables are allowed anywhere a block is allowed (including inside
        // <div>, <section>, etc.), not just directly under $root.
        allowWhere: '$block',
        isBlock: true,
        allowContentOf: '$block',
      });

      // After registering 'table', before converters.
      if (editor.model.schema.isRegistered('caption')) {
        editor.model.schema.extend('caption', {
          allowIn: 'table',
          allowContentOf: '$block',
          isLimit: true,
        });
      }
      else {
        editor.model.schema.register('caption', {
          allowIn: 'table',
          allowContentOf: '$block',
          isLimit: true,
          isBlock: true,
        });
      }

      for (const tag of ['thead', 'tbody', 'tfoot']) {
        editor.model.schema.register(tag, {
          allowIn: 'table',
          isLimit: true,
        });
      }

      editor.model.schema.register('tr', {
        allowIn: ['thead', 'tbody', 'tfoot'],
        isLimit: true,
        allowAttributes: ['scope', 'colspan', 'rowspan', 'headers', 'id', 'class', 'style'],
      });

      for (const cell of ['td', 'th']) {
        editor.model.schema.register(cell, {
          allowIn: 'tr',
          allowContentOf: '$block',
          isLimit: true,
          allowAttributes: ['scope', 'colspan', 'rowspan', 'headers', 'id', 'class', 'style'],
        });
      }

      // Simple view-model converters
      elements.forEach((tag) => {
        editor.conversion.elementToElement({ model: tag, view: tag });
      });

      ['th', 'td', 'tr', 'caption'].forEach(tag => {
        ['scope', 'colspan', 'rowspan', 'headers', 'id', 'class', 'style'].forEach(attr => {
          editor.conversion.for('upcast').attributeToAttribute({
            view: { name: tag, key: attr },
            model: attr
          });

          editor.conversion.for('downcast').attributeToAttribute({
            model: attr,
            view: attr
          });
        });
      });

      // Deal with faux-button.
      editor.ui.componentFactory.add('cke5_table_fix_dummy', () => null);

    }
  }

  // Expose plugin for Drupal CKEditor 5 loader
  window.CKEditor5 = window.CKEditor5 || {};
  window.CKEditor5.ckeditor5_table_fix = {
    CKEditor5TableFixPlugin: CKEditor5TableFixPlugin
  };
})();
