# CKEditor5 Table Fix

**CKEditor5 Table Fix** is a lightweight Drupal module that restores full HTML table markup support in CKEditor 5 for Drupal 10 and 11 — especially for sites upgraded from CKEditor 4 where existing semantic or accessibility-focused table markup must be preserved.

Out of the box, CKEditor 5 tends to normalize or strip some valid table structures (like `<tfoot>`, certain attributes on `<th>`, captions, or nested markup inside cells). This module focuses on *not* “improving” your tables, but on **stopping CKEditor 5 from breaking tables you already have**.

---

## Features

- **Preserves table structure and semantics**
  - Keeps `<thead>`, `<tbody>`, `<tfoot>`, `<caption>`, `<th>`, `<td>`, `<tr>` and their hierarchy intact.
  - Allows semantic wrappers around tables such as `<section>` and `<div>`.
- **Preserves key table attributes**
  - Supports attributes like `scope`, `colspan`, `rowspan`, `headers`, `id`, `class`, `style` on table-related elements.
  - Restores attributes that CKEditor 5 might otherwise drop on elements like `<th>` and `<caption>`.
- **Respects nested and “complex” content inside table cells**
  - Supports nested structures inside `<td>`/`<th>`, such as:
    - `<div class="wb-fnote">` footnote wrappers
    - `<dl><dt><dd>…</dd></dt></dl>` definition lists
    - Lists (`<ul>`, `<ol>`, `<li>`) in table cells and footers
    - Paragraphs with classes (e.g., `<p class="fn-rtn">…</p>`) used for footnote return links
- **Dummy toolbar button for easy enablement**
  - Exposes a faux CKEditor 5 button (`Table Fix Dummy`) so the plugin can be attached per text format using the normal Drupal “drag a button into the toolbar” workflow.
  - The button does *not* render a visible icon in the editor; it just ensures the plugin is loaded for that text format.
- **No UX changes for editors**
  - The module does not add any new UI for creating or editing tables.
  - Editors keep using the existing workflow; the benefit is that their markup survives round-trips through CKEditor 5.

---

## Use cases

Typical scenarios where this module helps:

- Government, higher-ed, and enterprise sites with **legacy semantic HTML tables** that must not be “simplified” by CKEditor 5.
- **WCAG-compliant data tables** that rely on:
  - `<caption>`
  - `<th scope="row|col">` and header associations via `headers`/`id`
  - Structured footnotes inside `<tfoot>`
- Sites that migrated from **CKEditor 4 to CKEditor 5** and discovered:
  - Footnote structures under `<tfoot>` are flattened.
  - Classes were stripped from `<caption>` or `<th>`
  - Nested tags inside cells are normalized into plain text.
  - `<ol>` / `<ul>` lists were dropped inside `<td>`

If you care more about preserving the **exact HTML** you already have than about CKEditor 5’s “opinionated” normalization, this module is for you.

---

## Requirements

- Drupal **10** or **11**
- CKEditor 5 enabled for the target text format(s)

No additional contrib dependencies are required.

---

## Installation

Using Composer:

```
composer require drupal/ckeditor5_table_fix:^1.0
```

Enable the module:

```
drush en ckeditor5_table_fix -y
```

or via the **Extend** UI at:

```
/admin/modules
```

---

## Configuration

1. **Pick the text format(s)**
   Navigate to:

   `/admin/config/content/formats`

2. **Disable the core CKEditor 5 table plugin**
   Inside the text format(s) where you want full markup preserved, disable the built‑in CKEditor 5 “Table” plugin.

3. **Enable CKEditor5 Table Fix**
   - Under the CKEditor 5 plugin list, enable **CKEditor5 Table Fix**.
   - In the toolbar layout area, drag **“Table Fix Dummy”** into the active toolbar.

4. **Save configuration**
   No visible button will appear in the editor — this is expected. The dummy button only signals Drupal to load the plugin.

5. **Verify**
   Paste a complex table containing:

   - `<tfoot>`, `<thead>`, `<tbody>`
   - `<caption class="…">`
   - Footnotes using `<dl><dt><dd>`
   - Nested lists (`<ol>`, `<ul>`, `<li>`)
   - `<p>` with classes inside table cells

   A full sample is available here:
   https://www.drupal.org/project/ckeditor5_table_fix#sample-markup

   Save the content, reload, and confirm the structure, tags, and attributes remain intact.


---

## How it works

- Adds CKEditor 5 schema definitions for:
  - `table`, `thead`, `tbody`, `tfoot`, `tr`, `td`, `th`, `caption`
- Maps HTML ↔ model for these elements so CKEditor does not strip or normalize them.
- Allows table cells to contain more complex nested content (`div`, `dl`, `dt`, `dd`, paragraphs with classes, etc.).
- Integrates `htmlSupport.GeneralHtmlSupport` to preserve important table‑level attributes.

The goal is preservation, not enforcement or simplification.

---

## Version notes

- **1.0.3** – Stable release with core preservation fixes.
- **1.0.4–1.0.6** – Improved handling of complex nested structures inside `<tfoot>`, support for paragraph classes inside `<dd>`, and attribute preservation enhancements.
- **1.0.7** – Adds list support (`ul`, `ol`, `li`) inside table cells and restores list classes

See the project’s Drupal.org issue queue for full details.

---

## Limitations

- CKEditor or browsers may still insert `<tbody>` automatically.
- Whitespace and indentation may normalize.
- The module does not validate accessibility or add new table editing UI.

Report any patterns that still break so they can be addressed.

---

## Contributing

Submit issues or patches via the Drupal.org project page:

https://www.drupal.org/project/ckeditor5_table_fix

When reporting a bug, include:

- Before and after HTML
- Drupal core version
- Module version
- Any other editor‑related modules

---

## Maintainers

- **smulvih2**
- **joseph.olstad**

---

## License

GPL v2 or later (same as Drupal core).
