# Contributing Guidelines

## Commit Standards

We follow [Conventional Commits](https://www.conventionalcommits.org/) for all commit messages and PR titles.

### Format 

<type>(<scope>): <description>
[optional body]
[optional footer(s)]

### Types
- `feat`: New features
- `fix`: Bug fixes
- `docs`: Documentation changes
- `style`: Code style changes (formatting, semicolons, etc)
- `refactor`: Code refactoring
- `test`: Adding or modifying tests
- `chore`: Maintenance tasks
- `perf`: Performance improvements
- `ci`: CI/CD changes
- `build`: Build system changes
- `revert`: Reverting changes

### Examples

feat(ui): add AI assist button to editor toolbar
fix(api): resolve token validation issue
docs(readme): update installation instructions
chore(deps): update dependencies
