import { Plugin } from 'ckeditor5/src/core';
import { ButtonView } from 'ckeditor5/src/ui';
import icon from '../../../../icons/cite.svg';
import CitationCommand from './CitationCommand';

export default class CitationCke5 extends Plugin {
  init() {
      const editor = this.editor;

      // Register the Citation Command
      editor.commands.add('citationCke5', new CitationCommand(editor));

      // Add the button to the toolbar
      editor.ui.componentFactory.add('citationCke5', locale => {
          const button = new ButtonView(locale);

          button.set({
              label: 'Citation CKE5',
              icon: icon,
              tooltip: true,
              withText: false, // Optional, depending on design
          });

          // Bind button state to the command
        const command = editor.commands.get('citationCke5');
        button.bind('isOn', 'isEnabled').to(command, 'value', 'isEnabled');

          // Execute the command when the button is clicked
          this.listenTo(button, 'execute', () => {
              editor.execute('citationCke5');
          });

          return button;
      });

      editor.model.schema.extend('$text', { allowAttributes: 'cite' });

      editor.conversion.attributeToElement({
        model: 'cite',
        view: 'cite',
        upcastAlso: {
            // Ensure any `<cite>` element in the raw HTML is properly converted to the "cite" attribute
            name: 'cite',
        },
    });
    
  }
}