//import Command from 'ckeditor/ckeditor5-core/src/command';
import { Command } from 'ckeditor5/src/core';


export default class CitationCommand extends Command {
    execute() {
        const editor = this.editor;
        const model = editor.model;

        model.change(writer => {
            const selection = model.document.selection;
            if (selection.isCollapsed) {
                // Check if the "cite" attribute is already applied
                const isCited = selection.hasAttribute('cite');

                if (isCited) {
                    // Remove the "cite" attribute from the selection
                    writer.removeSelectionAttribute('cite');
                    editor.editing.view.focus();
                } else {
                    // Apply the "cite" attribute to the selection
                    writer.setSelectionAttribute('cite', true);
                    editor.editing.view.focus();
                }
            } else {
                // Get the range of the selected text
                const ranges = model.schema.getValidRanges(selection.getRanges(), 'cite');

                for (const range of ranges) {
                    if (selection.hasAttribute('cite')) {
                        // Remove the 'cite' attribute from the selected text
                        writer.removeAttribute('cite', range);
                        editor.editing.view.focus();
                        writer.setSelection(range);
                    } else {
                        // Apply the 'cite' attribute to the selected text
                        writer.setAttribute('cite', true, range);
                        editor.editing.view.focus();
                        writer.setSelection(range);
                    }
                }
            }
        });
    }

    refresh() {
        const selection = this.editor.model.document.selection;
        // Check if the command should be enabled
        this.isEnabled = true; // Always enabled for simplicity
        this.value = selection.hasAttribute('cite');
    }
}