/**
 * @file
 * CKEditor InfoCard functionality.
 */

(function (Drupal, drupalSettings) {
  'use strict';
  Drupal.behaviors.text = {
    scrollEventFunc: null,
    attach(context) {
      once(
        'js-infoCard',
        context.querySelectorAll('.js-infoCard'), // info card
      ).forEach((container) => this._init(container));
    },

    /**
     *
     * @param {HTMLElement} infoCard
     * @public
     */
    open(infoCard) {
      infoCard.classList.add('is-open');

      const hint = infoCard.children[0];
      // A default behaviour

      const infoCardContent = infoCard.children[1];
      infoCardContent.style.display = 'block';
      infoCard.ariaExpanded = 'true';


    },
    /**
     *
     * @param {HTMLElement} infoCard
     * @public
     */
    close(infoCard) {
      infoCard.classList.remove('is-open');
      // const hint = infoCard.children[0];
      // A default behaviour
      const infoCardContent = infoCard.children[1];
      infoCardContent.style.display = 'none';
      infoCard.ariaExpanded = 'false';
    },
    /**
     *
     * @param {HTMLElement} infoCard
     * @public
     */
    toggle(infoCard) {
      if (infoCard.classList.contains('is-open')) {
        this.close(infoCard);
        return;
      }
      this.open(infoCard);
    },

    /**
     *
     * @param {HTMLElement} infoCard
     * @private
     */
    _init(infoCard) {
      infoCard.classList.add('infocard');
      const hint = infoCard.innerText;
      infoCard.innerText = '';

      const infoCardHint = document.createElement('span');
      infoCardHint.classList.add('infocard__hint');
      infoCardHint.innerText = hint;
      infoCardHint.tabIndex = 0;
      infoCard.appendChild(infoCardHint);

      const infoCardContent = document.createElement('span');
      infoCardContent.classList.add('infocard__content');
      infoCardContent.style.display = 'none';
      infoCardContent.innerHTML = infoCard.attributes['data-content'].value;
      infoCard.appendChild(infoCardContent);
      infoCard.ariaExpanded = 'false';

      infoCardHint.addEventListener('click', () => this.toggle(infoCard));
      infoCardHint.addEventListener('keypress', (infoCardEvent) => {
        if (infoCardEvent.key === 'Enter'){
          this.toggle(infoCard);

        }
      });
    }
  };
})(Drupal, drupalSettings);
