<?php

declare(strict_types=1);

namespace Drupal\ckeditor_media_edit\Plugin\CKEditor5Plugin;

use Drupal\ckeditor5\Plugin\CKEditor5PluginConfigurableInterface;
use Drupal\ckeditor5\Plugin\CKEditor5PluginConfigurableTrait;
use Drupal\ckeditor5\Plugin\CKEditor5PluginDefault;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\editor\EditorInterface;

/**
 * CKEditor 5 EditMediaModal plugin.
 *
 * @internal
 *   Plugin classes are internal.
 */
final class EditMediaModal extends CKEditor5PluginDefault implements CKEditor5PluginConfigurableInterface {

  use CKEditor5PluginConfigurableTrait;

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return ['form_mode' => 'default'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['form_mode'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Form mode'),
      '#description' => $this->t('Note: if changing this value, make sure that the form mode exists on the entity type where this editor will be used.'),
      '#default_value' => $this->configuration['form_mode'],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state): void {
    // Match the config schema structure at
    // ckeditor5.plugin.ckeditor5_imageResize.
    $form_value = $form_state->getValue('form_mode');
    $form_state->setValue('form_mode', (string) $form_value);
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {
    $this->configuration['form_mode'] = $form_state->getValue('form_mode');
  }

  /**
   * {@inheritdoc}
   */
  public function getDynamicPluginConfig(array $static_plugin_config, EditorInterface $editor): array {
    $static_plugin_config['editMediaModal']['formMode'] = $this->configuration['form_mode'];
    // Set base URL in case the site had a prefix (like the GitLab test runner).
    $static_plugin_config['editMediaModal']['baseUrl'] = Url::fromRoute('<front>', [], ['absolute' => TRUE])->toString();

    return $static_plugin_config;
  }

}
