<?php

declare(strict_types=1);

namespace Drupal\ckeditor_media_edit\Hook;

use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\CloseModalDialogCommand;
use Drupal\Core\Ajax\ReplaceCommand;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\editor\Ajax\EditorDialogSave;

/**
 * Edit Media Modal Hooks.
 */
final class EditMediaModalHooks {

  private const FORM_SELECTOR = 'data-edit-media-modal';

  /**
   * Implements hook_form_BASE_FORM_ID_alter().
   */
  #[Hook('form_media_form_alter')]
  public function mediaFormAlter(array &$form, FormStateInterface $form_state): void {
    if ($form_state->get('ckeditor_media_edit') !== TRUE) {
      return;
    }
    $form['actions']['submit']['#ajax'] = [
      'callback' => [self::class, 'ajaxSubmit'],
    ];
    unset($form['actions']['delete']);
    unset($form['actions']['cancel']);

    $form['#attributes'][self::FORM_SELECTOR] = '';
  }

  /**
   * Close dialog ajax callback.
   */
  public static function ajaxSubmit(array $form, FormStateInterface $form_state): AjaxResponse {
    $response = new AjaxResponse();
    if ($form_state::hasAnyErrors()) {
      $form['status_messages'] = [
        '#type' => 'status_messages',
        '#weight' => -1000,
      ];
      $form['#sorted'] = FALSE;
      $response->addCommand(new ReplaceCommand('[' . self::FORM_SELECTOR . ']', $form));
      return $response;
    }
    \Drupal::messenger()->deleteAll();

    $values = [
      'edit-media-modal' => TRUE,
    ];
    $response->addCommand(new EditorDialogSave($values));
    $response->addCommand(new CloseModalDialogCommand());

    return $response;
  }

}
