# CKEditor 5 Media Image Style

**Apply different image styles to embedded media images directly in CKEditor 5**

This module adds a simple button to the CKEditor 5 media toolbar, allowing content editors — even those new to Drupal — to select an image style (thumbnail, medium, large, etc.) for each embedded media image individually.

No need to create multiple view modes or write custom code. Editors get full flexibility while keeping image management reusable through the Media library.

![Screenshot of the image style selector button and dropdown in CKEditor 5](screenshot.png)
*(Add a real screenshot of the editor toolbar and dropdown once available)*

## Features

- Per-embed image style selection (independent of global view modes)
- Dropdown selector with all configured image styles + "Original (no style)" option
- Live preview in the editor using dynamic CSS based on style dimensions
- Seamless integration with Drupal's Media and Image Style systems
- Configurable per text format: enable/disable and limit available styles
- Works out-of-the-box with scale, crop, and resize effects

## Use Cases

- Blog posts mixing small thumbnails and large hero images
- News articles with inline images of varying widths
- Landing pages needing precise image sizing without developer help
- Any site where non-technical editors control layout and design

## Requirements

- Drupal ^10 or ^11
- CKEditor 5 (core)
- Media (core)
- Image (core)

No additional contributed modules or external libraries required.

## Installation & Configuration

1. Install and enable the module as usual (`drush en ckeditor_media_image_style` or via Extend).
2. Go to **Configuration → Content authoring → Text formats and editors**  
   (`/admin/config/content/formats`)
3. Edit the text format where you want the feature (e.g., Full HTML).
4. **Enabled filters** section:
   - Check **"Extract image styles from embedded media"**
   - Drag it so it runs **before** the "Embed media" filter (critical!)
5. **CKEditor 5 plugin settings** section:
   - Find **"Media Image Style Selector"**
   - Check **"Enable media image style selector"**
   - Optionally select specific image styles (leave empty to allow all)
6. Save the text format.

### Usage

1. While editing content, insert an image using the **Media** button.
2. Click the embedded image to select it.
3. A new toolbar button with an image style icon appears.
4. Click it → choose the desired style → **Save**.
5. The image will render with the selected style on the front end.

## Similar Modules

- **[CKEditor Media Resize](https://www.drupal.org/project/ckeditor_media_resize)**  
  Offers nearly identical functionality. Choose the one with better maintenance or compatibility for your setup.

- Core view mode overrides  
  More rigid; requires creating and managing multiple view modes for each combination.

## Recommended Complementary Modules

- **Focal Point** or **Crop