<?php

namespace Drupal\ckeditor_media_image_style\Plugin\Filter;

use Drupal\Component\Utility\Html;
use Drupal\filter\FilterProcessResult;
use Drupal\filter\Plugin\FilterBase;

/**
 * Provides a filter to extract image styles from embedded media.
 *
 * @Filter(
 *   id = "media_image_style",
 *   title = @Translation("Extract image styles from embedded media"),
 *   description = @Translation("Must run before the media embed filter."),
 *   type = Drupal\filter\Plugin\FilterInterface::TYPE_TRANSFORM_REVERSIBLE,
 *   weight = -10
 * )
 */
class MediaImageStyleFilter extends FilterBase {

  /**
   * {@inheritdoc}
   */
  public function process($text, $langcode) {
    $result = new FilterProcessResult($text);

    if (stristr($text, 'data-image-style') === FALSE) {
      return $result;
    }

    $dom = Html::load($text);
    $xpath = new \DOMXPath($dom);

    $media_elements = $xpath->query('//drupal-media[@data-image-style]');

    foreach ($media_elements as $element) {
      $image_style = $element->getAttribute('data-image-style');
      $uuid = $element->getAttribute('data-entity-uuid');

      if ($uuid && $image_style) {
        $styles = &drupal_static('ckeditor_media_image_style_by_uuid', []);
        $styles[$uuid] = $image_style;
      }
    }

    return $result;
  }

}