# CKEditor 5 Media Title Override

**Drupal module that allows content editors to override the `title` attribute of embedded media entities (especially images) directly within CKEditor 5.**

By default, when a media entity is embedded using Drupal's Media Embed filter, the HTML `<drupal-media>` element uses the media entity's title as its `title` attribute (used for tooltips and accessibility). This module adds a simple toolbar button that lets editors set a custom `title` value **per content instance**, without modifying the original media entity.

## Features

- Adds a "Override media image title" button (with a "T" icon) to the inline toolbar when a `<drupal-media>` entity is selected in CKEditor 5.
- Opens a native-style contextual balloon form to enter custom title text.
- Leave the field blank to fall back to the media entity's default title.
- Override is stored only in the current content – the original media entity remains unchanged.
- Fully configurable per text format.
- Lightweight and built specifically for Drupal 10/11 + CKEditor 5.

## Use Cases

- Provide context-specific tooltips for the same image used in multiple articles.
- Improve accessibility with more descriptive titles in specific contexts.
- Avoid editing the central media library asset just to change a tooltip.
- Multilingual or multi-purpose sites where the default title isn't always appropriate.

## Requirements

- Drupal ^10 or ^11
- CKEditor 5 (included in core)
- Media module (core)
- A text format using **CKEditor 5** and the **Media Embed** filter

No external libraries required.

## Installation

1. Install the module as usual (via Composer or download):